#include <windows.h>
#include <assert.h>

#include "JPEGLIB.h"
#include "JINCLUDE.h"
//#include <stdio.h>

/*
 * This code is loosely based on ppmtogif from the PBMPLUS distribution
 * of Feb. 1991.  That file contains the following copyright notice:
 *    Based on GIFENCODE by David Rowley <mgardi@watdscu.waterloo.edu>.
 *    Lempel-Ziv compression based on "compress" by Spencer W. Thomas et al.
 *    Copyright (C) 1989 by Jef Poskanzer.
 *    Permission to use, copy, modify, and distribute this software and its
 *    documentation for any purpose and without fee is hereby granted, provided
 *    that the above copyright notice appear in all copies and that both that
 *    copyright notice and this permission notice appear in supporting
 *    documentation.  This software is provided "as is" without express or
 *    implied warranty.
 *
 * We are also required to state that
 *    "The Graphics Interchange Format(c) is the Copyright property of
 *    CompuServe Incorporated. GIF(sm) is a Service Mark property of
 *    CompuServe Incorporated."
 */
//#include "cdjpeg.h"		/* Common decls for cjpeg/djpeg applications */

#define	MAX_LZW_BITS	12	/* maximum LZW code size (4096 symbols) */
typedef INT16 code_int;		/* must hold -1 .. 2**MAX_LZW_BITS */
#define LZW_TABLE_SIZE	((code_int) 1 << MAX_LZW_BITS)
#define HSIZE		5003	/* hash table size for 80% occupancy */
typedef int hash_int;		/* must hold -2*HSIZE..2*HSIZE */
#define MAXCODE(n_bits)	(((code_int) 1 << (n_bits)) - 1)
/*
 * The LZW hash table consists of two parallel arrays:
 *   hash_code[i]	code of symbol in slot i, or 0 if empty slot
 *   hash_value[i]	symbol's value; undefined if empty slot
 * where slot values (i) range from 0 to HSIZE-1.  The symbol value is
 * its prefix symbol's code concatenated with its suffix character.
 *
 * Algorithm:  use open addressing double hashing (no chaining) on the
 * prefix code / suffix character combination.  We do a variant of Knuth's
 * algorithm D (vol. 3, sec. 6.4) along with G. Knott's relatively-prime
 * secondary probe.
 *
 * The hash_value[] table is allocated from FAR heap space since it would
 * use up rather a lot of the near data space in a PC.
 */
typedef INT32 hash_entry;	/* must hold (code_int<<8) | byte */
#define HASH_ENTRY(prefix,suffix)  ((((hash_entry) (prefix)) << 8) | (suffix))



class GIF
{
public:
	enum GIF_FORMAT {	GIF87a, GIF89a	};
	GIF(unsigned int _width,unsigned int _height,int _num_colors,unsigned char* _colormap,unsigned char* _pixelbuffer);
	~GIF();
	boolean WriteFile(const char* filename, GIF_FORMAT gf=GIF89a);
   boolean Gif87aToGif89a(const char* sourceFilename, const char* destFilename);

private:
	FILE* output_file;
	unsigned int width;
	unsigned int height;
	int num_colors;
	J_COLOR_SPACE out_color_space;
	unsigned char* colormap;
	unsigned char* pixelbuffer;

	j_decompress_ptr cinfo;	/* back link saves passing separate parm */

	/* State for packing variable-width codes into a bitstream */
	int n_bits;			/* current number of bits/code */
	code_int maxcode;		/* maximum code, given n_bits */
	int init_bits;		/* initial n_bits ... restored after clear */
	INT32 cur_accum;		/* holds bits not yet output */
	int cur_bits;			/* # of bits in cur_accum */

	/* LZW string construction */
	code_int waiting_code;	/* symbol not yet output; may be extendable */
	boolean first_byte;		/* if TRUE, waiting_code is not valid */

	/* State for LZW code assignment */
	code_int ClearCode;		/* clear code (doesn't change) */
	code_int EOFCode;		/* EOF code (ditto) */
	code_int free_code;		/* first not-yet-used symbol code */

	/* LZW hash table */
	code_int *hash_code;		/* => hash table of symbol codes */
	hash_entry FAR *hash_value;	/* => hash table of symbol values */

	/* GIF data packet construction buffer */
	int bytesinpkt;		/* # of bytes in current packet */
	char packetbuf[256];		/* workspace for accumulating packet */


	void HeaderWriteFile();
	void PixelsWriteFile();
	void FinishWriteFile();
	void compress_init(int i_bits);/* Initialize LZW compressor */
	void compress_byte(int c);
	void compress_term();
	void clear_hash();			/* Fill the hash table with empty entries */
	void clear_block();
	void output (code_int code);/* Emit a code of n_bits bits */
								/* Uses cur_accum and cur_bits to reblock into 8-bit bytes */
	void CHAR_OUT(char c);		/* Add a character to current packet; flush to disk if necessary */
	void flush_packet();		/* flush any accumulated data */

void transdata(FILE* src, FILE* dest);
void transblock(FILE* src, FILE* dest);


};


